/**
 * 
 */
package gov.va.genisis2.util;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.genisis2.util.rest.helper.ResponseWrapper;

/**
 * @author Paramjeet Bindra
 * @author Getaneh Kassahun
 *
 */
public final class FortifyHelper {
	private static final Logger LOGGER = LoggerFactory.getLogger(FortifyHelper.class);

	public static ResponseWrapper cleanWrapper(ResponseWrapper wrapper) {
		JSONObject json = null;
		ResponseWrapper cleanWrapper = new ResponseWrapper();
		Object cleanObject = getCleanObject(wrapper.getResponse());
		String cleanObjectString = StringUtils.EMPTY;
		if (cleanObject != null) {
			cleanObjectString = convertObjectString(cleanObject);
		}
		cleanWrapper.setMessage(ESAPI.encoder().encodeForHTMLAttribute(wrapper.getMessage()));
		cleanWrapper.setSuccess(wrapper.getSuccess());
		cleanWrapper.setResponse((Object) ESAPI.encoder().encodeForHTMLAttribute(cleanObjectString));
		try {
			String decode = ESAPI.encoder().decodeForHTML((String) cleanWrapper.getResponse());
			Object wrapperObject = wrapper.getResponse();
			JSONParser parser = new JSONParser();
			JSONObject jsonObject = new JSONObject();
			if (wrapperObject instanceof ArrayList<?>) {
				Object decodedObject = parser.parse(decode);
				decodedObject = getUnEscapedObject(decodedObject);
				cleanWrapper.setResponse(decodedObject);
			} else {
				Boolean validJson = JSONUtils.isJSONValid(decode);
				if (validJson) {
					decode = StringEscapeUtils.unescapeHtml(decode);
					jsonObject = (JSONObject) new JSONParser().parse(decode);
					cleanWrapper.setResponse(jsonObject);
				}
				else {
				cleanWrapper.setResponse(parser.parse(decode));
				}
			}
		} catch (ParseException e) {
			LOGGER.error("Error while creating Clean Wrapper", e.getMessage());
		}
		return cleanWrapper;
	}

	private static Object getCleanObject(Object object) {
		if (object instanceof ArrayList<?>) {
			int objectSize = ((ArrayList) object).size();
			for (int i = 0; i < objectSize; i++) {
				Object obj = ((ArrayList<?>) object).get(i);
				applyESAPIObjectStringFields(obj);
			}
		} else {
			applyESAPIObjectStringFields(object);
		}
		return object;
	}

	private static Object applyESAPIObjectStringFields(Object object) {
		for (Field field : object.getClass().getDeclaredFields()) {
			if (field.getType().isAssignableFrom(String.class)) {
				field.setAccessible(true);
				try {
					String fieldValue = (String) field.get(object);
					String cleanValue = ESAPI.encoder().encodeForHTMLAttribute(fieldValue);
					field.set(object, cleanValue);
				} catch (SecurityException | IllegalArgumentException | IllegalAccessException e) {
					LOGGER.error("Error while encoding an Object using ESAPI ");
				}
			}
		}
		return object;
	}

	private static String convertObjectString(Object object) {
		String objectCleanString = StringUtils.EMPTY;
		ObjectMapper objectMapper = new ObjectMapper();
		StringWriter stringWriter = new StringWriter();
		objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
		try {
			objectMapper.writeValue(stringWriter, object);
			objectCleanString = stringWriter.toString();
		} catch (IOException e) {
			LOGGER.error("Error while conveting an Object to String");
		}
		return objectCleanString;
	}

	private static Object getUnEscapedObject(Object object) {
		if (object instanceof ArrayList<?>) {
			int objectSize = ((ArrayList) object).size();
			for (int i = 0; i < objectSize; i++) {
				Object obj = ((ArrayList<?>) object).get(i);
				applyUnEscapeHTMLStringFields(obj);
			}
		}
		return object;
	}

	private static Object applyUnEscapeHTMLStringFields(Object object) {
		JSONObject json = (JSONObject) object;
		Iterator it = json.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry pair = (Map.Entry) it.next();
			if (pair.getValue() instanceof String) {
				pair.setValue(StringEscapeUtils.unescapeHtml(pair.getValue().toString()));
			}
		}
		return object;
	}

	public static String getCleanStringInput(String input) {
		String cleanValue = StringUtils.EMPTY;
		try {
			cleanValue = getValidator().getValidInput("logMessage", input, "SafeString", 100, false);
		} catch (ValidationException e) {
			LOGGER.error("Error while encoding input using ESAPI");
		}
		return cleanValue;
	}

	public static String getCleanStringEmail(String email) {
		String cleanEmail = StringUtils.EMPTY;
		try {
			cleanEmail = getValidator().getValidInput("logMessage", email, "Email", 100, false);
		} catch (ValidationException e) {
			LOGGER.error("Error while encoding Email using ESAPI ");
		}
		return cleanEmail;
	}
	
	public static List<String> getCleanListOfString(List<String> inputs) {
		List<String> cleanStrings = new ArrayList<>();
		for (String input : inputs) {
			try {
				cleanStrings.add(getValidator().getValidInput("logMessage", input, "SafeString", 100, false));
			} catch (ValidationException e) {
				LOGGER.error("Error while encoding input using ESAPI");
			}
		}
		return cleanStrings;
	}

	private static Validator getValidator() {
		return ESAPI.validator();
	}
}
